﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using MicroRWD.Common;
using MicroRWD.QT;

namespace MicroRWD.UI.QT
{
    public partial class H400X_MemoryPanel : UserControl
    {
        private Thread reader;

        public H400X_MemoryPanel()
        {
            InitializeComponent();
        }

        private void UpdateData(byte[] _data)
        {
            UpdateData(String.Join(string.Empty, Array.ConvertAll(_data, b => b.ToString("X2") + ' ')), String.Join(string.Empty, Array.ConvertAll(_data, b => ((b > 31) && (b < 127)) ? ((char)b).ToString() + ' ' : ". ")));
        }

        private void UpdateData(string _hex, string _ascii)
        {
            this.UIThread(() => hexTextBox.Text = _hex);
            this.UIThread(() => asciiTextBox.Text = _ascii);
        }

        // Reader thread
        private void Reader()
        {
            // Forever
            while (true)
            {
                // Wait a while
                Thread.Sleep(1000);

                // If reader is in EM400X mode read the tag data
                if (Program.Controller.Reader.Mode == Mode.EM400X)
                {
                    if (Program.Controller.Reader.ContinuousPoll)
                    {
                        // Read tag data
                        byte[] reply = Program.Controller.Reader.CmdTagRead(0);

                        // Check for reply
                        if (reply.Length > 0)
                        {
                            // Check for data
                            if (reply.Length == 6)
                            {
                                // Copy data to new array
                                byte[] data = new byte[5];
                                for (int i = 0; i < 5; ++i)
                                {
                                    data[i] = reply[i + 1];
                                }

                                // Update view(s)
                                UpdateData(data);
                            }
                            else
                            {
                                // Update view(s)
                                UpdateData("<NO DATA>", "");
                            }
                        }
                        else
                        {
                            // Update view(s)
                            UpdateData("", "");
                        }
                    }
                }
            }
        }

        private void H400X_MemoryPanel_Load(object sender, EventArgs e)
        {
            if (!DesignMode && (Program.Controller != null))
            {
                // Start reader thread
                reader = new Thread(Reader);
                reader.IsBackground = true;
                reader.Start();
            }
        }
    }
}
